Require Import Arith.
Require Import Program.

Program Fixpoint div2 (n: nat):
  { x: nat | n = 2 * x \/ n = 2 * x + 1 } :=
  match n with
  | S (S p) => S (div2 p)
  | _ => O
  end.
Obligation 1.
  destruct o.
    left. rewrite H. rewrite <- plus_n_O.
    rewrite plus_n_Sm. reflexivity.
    right. rewrite H. rewrite <- plus_n_O.
    rewrite <- (plus_n_Sm x x).
    rewrite plus_Sn_m. reflexivity.
Defined.
Obligation 2.
  destruct n.
    left. reflexivity.
    destruct n.
    right. reflexivity.
    absurd (n <> n).
      intro. apply H0. reflexivity.
      intro. apply (H n). reflexivity.
Qed.


    


